/* --------------------------------------------------------------
   account_emailaddress.js 2020-02-26
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

gambio.widgets.module('account_emailaddress', [], function(data) {
	'use strict';
	
	var $this = $(this),
		$body = $('body'),
		defaults = {
		},
		options = $.extend(true, {}, defaults, data),
		module = {};
	
	// ########## HELPER FUNCTIONS ##########
	
	// (none)
	
	// ########## INITIALIZATION ##########
	
	/**
	 * Init function of the widget
	 * @constructor
	 */
	module.init = function(done) {
		let $emailAddress = $('#email_address'),
			$emailConfirm = $('#email_address_confirm'),
			$emailInputs  = $('#email_address, #email_address_confirm'),
			$noMatchNote  = $('.email-no-match');
		
		$emailInputs.on('input', function() {
			let emailValue = $emailAddress.val(),
				confirmValue = $emailConfirm.val();
			console.log('*************************************************************************************************************************');
			console.log('********************************************************* input has changed *********************************************');
			console.log('*************************************************************************************************************************');
			if((emailValue.length > 0 || confirmValue.length > 0) &&
				emailValue !== confirmValue) {
				$noMatchNote.show();
				$emailAddress.closest('div.form-group').addClass('has-error');
				$emailConfirm.closest('div.form-group').addClass('has-error');
			} else {
				$noMatchNote.hide();
				$emailAddress.closest('div.form-group').removeClass('has-error');
				$emailConfirm.closest('div.form-group').removeClass('has-error');
				
				// remove help text indicating email address already exists
				$emailAddress.closest('div.form-group').find('.help-block').remove();
				$emailConfirm.closest('div.form-group').find('.help-block').remove();
				// check if password is okay and enable submit button upon a valid password
				if(!$('#password-option').hasClass('has-error')) {
					$('button[type="submit"]', $this.closest('form')).removeAttr('disabled');
				}
			}
		});
		
		done();
	};
	
	// Return data to widget engine
	return module;
});
